/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.nock_enough_arrows.events;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.resource.PathPackResources;

@Mod.EventBusSubscriber(modid="nock_enough_arrows", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PackLoadingEvent {
    public static final List<String> COMPATIBLE_MODS = new ArrayList<String>(){
        {
            this.add("apotheosis");
        }
    };

    @SubscribeEvent
    public static void onPackEvent(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            event.addRepositorySource((RepositorySource)new ModLoadedPackFinder());
        }
    }

    public static class ModLoadedPackFinder
    implements RepositorySource {
        public void m_7686_(Consumer<Pack> packLoader, Pack.PackConstructor packBuilder) {
            IModFileInfo modFile = ((ModContainer)ModList.get().getModContainerById("nock_enough_arrows").get()).getModInfo().getOwningFile();
            for (String modid : COMPATIBLE_MODS) {
                try {
                    if (!ModList.get().isLoaded(modid)) continue;
                    packLoader.accept(Pack.m_10430_((String)("Nock Enough Arrows Compat: " + modid), (boolean)false, () -> new PathPackResources("Tintent Compat: " + modid, modFile.getFile().findResource(new String[]{"compat_data_packs/" + modid + "/"})), (Pack.PackConstructor)packBuilder, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_));
                }
                catch (Exception exception) {}
            }
        }
    }
}

